/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.authentication.flows.AuthorizationCodeFlow;
import technicianlp.reauth.authentication.flows.DeviceCodeFlow;
import technicianlp.reauth.authentication.flows.Flow;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.FlowStage;
import technicianlp.reauth.authentication.flows.Flows;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.gui.AbstractScreen;
import technicianlp.reauth.session.SessionHelper;

public final class FlowScreen
extends AbstractScreen
implements FlowCallback {
    private Flow flow;
    private FlowStage stage = FlowStage.INITIAL;
    private String[] formatArgs = new String[0];
    private String errorText = null;

    public static <F extends Flow, P> F open(BiFunction<P, FlowCallback, F> flowConstructor, P param, boolean keepParent) {
        Flow flow;
        FlowScreen screen = new FlowScreen();
        screen.flow = flow = (Flow)flowConstructor.apply(param, screen);
        if (!keepParent) {
            Minecraft.m_91087_().popGuiLayer();
        }
        Minecraft.m_91087_().pushGuiLayer((Screen)screen);
        return (F)flow;
    }

    public FlowScreen() {
        super("reauth.gui.title.flow");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 196;
        int buttonWidthH = buttonWidth / 2;
        this.formatArgs = new String[0];
        this.errorText = null;
        if (this.stage == FlowStage.MS_AWAIT_AUTH_CODE && this.flow instanceof AuthorizationCodeFlow) {
            try {
                URL url = new URL(((AuthorizationCodeFlow)this.flow).getLoginUrl());
                this.m_142416_((GuiEventListener)new Button(this.centerX - buttonWidthH, this.baseY + this.screenHeight - 42, buttonWidth, 20, (Component)new TranslatableComponent("reauth.msauth.button.browser"), b -> Util.m_137581_().m_137650_(url)));
            }
            catch (MalformedURLException e) {
                ReAuth.log.error("Browser button failed", (Throwable)e);
            }
        } else if (this.stage == FlowStage.MS_POLL_DEVICE_CODE && this.flow instanceof DeviceCodeFlow) {
            try {
                DeviceCodeFlow flow = (DeviceCodeFlow)this.flow;
                if (CompletableFuture.allOf(flow.getLoginUrl(), flow.getCode()).isDone()) {
                    String urlString = flow.getLoginUrl().join();
                    String code = flow.getCode().join();
                    URL url = new URL(urlString);
                    this.m_142416_((GuiEventListener)new Button(this.centerX - buttonWidthH, this.baseY + this.screenHeight - 42, buttonWidth, 20, (Component)new TranslatableComponent("reauth.msauth.button.browser"), b -> Util.m_137581_().m_137650_(url)));
                    this.formatArgs = new String[]{urlString, code};
                }
            }
            catch (MalformedURLException e) {
                ReAuth.log.error("Browser button failed", (Throwable)e);
            }
        } else if (this.stage == FlowStage.FAILED) {
            this.errorText = Flows.getFailureReason(this.flow);
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        String text = I18n.m_118938_((String)this.stage.getRawName(), (Object[])this.formatArgs);
        ArrayList<String> lines = new ArrayList<String>();
        Collections.addAll(lines, text.split("\\R"));
        if (this.errorText != null) {
            lines.add("");
            Collections.addAll(lines, I18n.m_118938_((String)this.errorText, (Object[])new Object[0]).split("\\R"));
        }
        int height = lines.size() * 9;
        for (String s : lines) {
            if (!s.startsWith("$")) continue;
            height += 9;
        }
        int y = this.centerY - height / 2;
        for (String line : lines) {
            if (line.startsWith("$")) {
                line = line.substring(1);
                poseStack.m_85836_();
                poseStack.m_85841_(2.0f, 2.0f, 1.0f);
                this.f_96547_.m_92750_(poseStack, line, (float)(this.centerX - this.f_96547_.m_92895_(line)) / 2.0f, (float)y / 2.0f, -1);
                y += 18;
                poseStack.m_85849_();
                continue;
            }
            this.f_96547_.m_92750_(poseStack, line, (float)(this.centerX - this.f_96547_.m_92895_(line) / 2), (float)y, -1);
            y += 9;
        }
    }

    @Override
    public void m_7861_() {
        super.m_7861_();
        if (this.stage != FlowStage.FINISHED) {
            this.flow.cancel();
        }
    }

    @Override
    public void onSessionComplete(SessionData session, Throwable throwable) {
        if (throwable == null) {
            SessionHelper.setSession(session);
            ReAuth.log.info("Login complete");
        } else if (throwable instanceof CancellationException || throwable.getCause() instanceof CancellationException) {
            ReAuth.log.info("Login cancelled");
        } else {
            ReAuth.log.error("Login failed", throwable);
        }
    }

    @Override
    public void onProfileComplete(Profile profile, Throwable throwable) {
        if (throwable == null) {
            ReAuth.profiles.storeProfile(profile);
            ReAuth.log.info("Profile saved successfully");
        } else if (throwable instanceof CancellationException || throwable.getCause() instanceof CancellationException) {
            ReAuth.log.info("Profile saving cancelled");
        } else {
            ReAuth.log.error("Profile failed to save", throwable);
        }
    }

    @Override
    public void transitionStage(FlowStage newStage) {
        this.stage = newStage;
        ReAuth.log.info(this.stage.getLogLine());
        this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        if (newStage == FlowStage.MS_AWAIT_AUTH_CODE && this.flow instanceof AuthorizationCodeFlow) {
            try {
                Util.m_137581_().m_137650_(new URL(((AuthorizationCodeFlow)this.flow).getLoginUrl()));
            }
            catch (MalformedURLException e) {
                ReAuth.log.error("Failed to open page", (Throwable)e);
            }
        } else if (newStage == FlowStage.FINISHED) {
            this.requestClose(true);
        }
    }

    @Override
    public Executor getExecutor() {
        return ReAuth.executor;
    }
}

